<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Frame;
use App\Models\FrameCategory;
use Illuminate\Support\Str;
use ZipArchive;
use File;
use Storage;
use App\Models\Setting;

class AnimatedFrameController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['categories'] = FrameCategory::where('status','0')->orderBy('id', 'DESC')->get();
        $data['frames'] = Frame::orderBy('id', 'DESC')->where('frame_zip','!=','')->paginate(12);
        
        return view('frame.animated.index',$data);
    }
    
    public function filterby_category($id){
        
        $data['categories'] = FrameCategory::where('status','0')->orderBy('id', 'DESC')->get();
        $data['frames'] = Frame::where('category_id',$id)->where('frame_zip','!=','')->orderBy('id', 'DESC')->paginate(12);
        $data['category'] = FrameCategory::find($id)->name;
        return view('frame.animated.index',$data);
    }
    
    public function frame_status(Request $request)
    {
        // echo("okk");
        $posts = Frame::find($request->get("id"));
        $posts->status = ($request->get("checked")=="true")?0:1;
        $posts->save();
    }

    public function frame_premium_action(Request $request)
    {
        $festivals = Frame::find($request->get("id"));
        $festivals->premium = $request->get("type");
        $festivals->save();
    }
    
    public function frame_action(Request $request)
    {
        $ids = explode(",",$request->posts_ids);
        if($request->posts_ids != null)
        {
            if($request->action_type == "enable")
            {
                foreach($ids as $id){
                    $posts = Frame::find($id);
                    $posts->status = 0;
                    $posts->save();
                }
            }
    
            if($request->action_type == "disable")
            {
                foreach($ids as $id){
                    $posts = Frame::find($id);
                    $posts->status = 1;
                    $posts->save();
                }
            }
    
            if($request->action_type == "delete")
            {
                foreach($ids as $id){
                    
                    $posts = Frame::find($id);
                    @unlink($posts->thumbnail);
                    Frame::find($id)->delete();
                    
                }
            }
            
        }
        return redirect()->route("animatedframe.index");
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
        $data['categories'] = FrameCategory::where('status','0')->orderBy('id', 'DESC')->get();
        // echo(json_encode($data['posts']));
        // die();
        return view('frame.animated.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
             'image' => 'required',
             'title' => 'required',
             'category' => 'required',
             'premium' => 'required',
             'ratio' => 'required',
             'type' => 'required',
        ]);
        
        
        $sicker = new Frame();
        $sicker->title = $request->get("title");
        $sicker->type = $request->get("type");
        $sicker->premium = $request->get("premium");
        $sicker->category_id = $request->get("category");
        $sicker->ratio = $request->get("ratio");
        

        if ($request->hasFile('zip_file')) {

            $zipFile = $request->file('zip_file');
            $zipFileOriginalName = pathinfo($zipFile->getClientOriginalName(), PATHINFO_FILENAME).'_'.Str::random(15);
            $zipTitleName = pathinfo($zipFile->getClientOriginalName(), PATHINFO_FILENAME);
            $zipExtension = $zipFile->getClientOriginalExtension();
            $zipFileName = $zipTitleName. '.' .$zipExtension;
            
            if(Setting::getValue('storage_type') == "digitalOccean"){
                
                Storage::disk('spaces')->put('uploads/tamplate_frame/'.$zipFileOriginalName.$zipFileName, file_get_contents($zipFile),'public');
                $zipPath = env("DO_SPACES_URL").'/uploads/tamplate_frame/'.$zipFileOriginalName.$zipFileName;
                
            }else{
                $zipFile->move('uploads/tamplate_frame/'. $zipFileOriginalName, $zipFileName);
                $zipPath = 'uploads/tamplate_frame/'. $zipFileOriginalName. '/' .$zipFileName;
            }
            
            $sicker->frame_zip = $zipPath;
        }
        
        if ($request->file("image") && $request->file('image')->isValid()) {
            $image = $request->file("image");
            
            $extension = $image->getClientOriginalExtension();
            $fileName = Str::uuid() . '.' . $extension;
            
            if(Setting::getValue('storage_type') == "digitalOccean"){
                
                $item_url = Storage::disk('spaces')->put('uploads/thumbnail/'.$fileName, file_get_contents($image),'public');
                $thumbnail_url = env("DO_SPACES_URL").'/uploads/thumbnail/'.$fileName;
                
            }else{
                $thumbName = Str::uuid() . '.' .$extension;
                $image->move('uploads/thumbnail', $fileName);
                $item_url = 'uploads/thumbnail/'.$fileName;
                $thumbnail_url = 'uploads/thumbnail/'.$thumbName;
                switch($extension){ 
                    case 'jpeg':
                        $image = imagecreatefromjpeg($item_url); 
                        break; 
                    case 'png': 
                        $image = imagecreatefrompng($item_url); 
                        break; 
                    case 'gif': 
                        $image = imagecreatefromgif($item_url); 
                        break; 
                    default: 
                        $image = imagecreatefromjpeg($item_url); 
                }
                imagejpeg($image, $thumbnail_url, 50);
                
            }
            $sicker->thumbnail = $thumbnail_url;
        }
        $sicker->save();
        
        return redirect()->route('animatedframe.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        
        $data['frame'] = Frame::find($id);
        $data['categories'] = FrameCategory::where('status','0')->orderBy('id', 'DESC')->get();
        // echo(json_encode($data['posts']));
        // die();
        return view('frame.animated.edit',$data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
             'title' => 'required',
             'category' => 'required',
             'type' => 'required',
             'premium' => 'required',
             'ratio' => 'required',
        ]);
        
        $sicker = Frame::find($id);
        
        $sicker->type = $request->get("type");
        $sicker->premium = $request->get("premium");
        $sicker->ratio = $request->get("ratio");
        $sicker->category_id = $request->get("category");
        $sicker->title = $request->get("title");
        
        if ($request->hasFile('zip_file')) {

            $zipFile = $request->file('zip_file');
            $zipFileOriginalName = pathinfo($zipFile->getClientOriginalName(), PATHINFO_FILENAME).'_'.Str::random(15);
            $zipTitleName = pathinfo($zipFile->getClientOriginalName(), PATHINFO_FILENAME);
            $zipExtension = $zipFile->getClientOriginalExtension();
            $zipFileName = $zipTitleName. '.' .$zipExtension;
            
            if(Setting::getValue('storage_type') == "digitalOccean"){
                
                Storage::disk('spaces')->put('uploads/tamplate_frame/'.$zipFileOriginalName.$zipFileName, file_get_contents($zipFile),'public');
                $zipPath = env("DO_SPACES_URL").'/uploads/tamplate_frame/'.$zipFileOriginalName.$zipFileName;
                
            }else{
                $zipFile->move('uploads/tamplate_frame/'. $zipFileOriginalName, $zipFileName);
                $zipPath = 'uploads/tamplate_frame/'. $zipFileOriginalName. '/' .$zipFileName;
            }
            @unlink($sicker->frame_zip);
            $sicker->frame_zip = $zipPath;
        }
        
        if ($request->file("image") && $request->file('image')->isValid()) {
            $image = $request->file("image");
            
            $extension = $image->getClientOriginalExtension();
            $fileName = Str::uuid() . '.' . $extension;
            
            if(Setting::getValue('storage_type') == "digitalOccean"){
                
                $item_url = Storage::disk('spaces')->put('uploads/thumbnail/'.$fileName, file_get_contents($image),'public');
                $thumbnail_url = env("DO_SPACES_URL").'/uploads/thumbnail/'.$fileName;
                
            }else{
                $thumbName = Str::uuid() . '.' .$extension;
                $image->move('uploads/thumbnail', $fileName);
                $item_url = 'uploads/thumbnail/'.$fileName;
                $thumbnail_url = 'uploads/thumbnail/'.$thumbName;
                switch($extension){ 
                    case 'jpeg':
                        $image = imagecreatefromjpeg($item_url); 
                        break; 
                    case 'png': 
                        $image = imagecreatefrompng($item_url); 
                        break; 
                    case 'gif': 
                        $image = imagecreatefromgif($item_url); 
                        break; 
                    default: 
                        $image = imagecreatefromjpeg($item_url); 
                }
                imagejpeg($image, $thumbnail_url, 50);
                
            }
            @unlink($sicker->thumbnail);
            $sicker->thumbnail = $thumbnail_url;
        }
        
        $sicker->save();
        return redirect()->route('animatedframe.index');
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $sicker = Frame::find($id);
        @unlink($sicker->thumbnail);
        Frame::find($id)->delete();
        
        return redirect()->route('animatedframe.index');
    }
}
